/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl.gui;

import com.google.common.collect.ImmutableList;
import dev.isxander.yacl.api.ConfigCategory;
import dev.isxander.yacl.api.Option;
import dev.isxander.yacl.api.OptionGroup;
import dev.isxander.yacl.api.utils.Dimension;
import dev.isxander.yacl.gui.AbstractWidget;
import dev.isxander.yacl.gui.LowProfileButtonWidget;
import dev.isxander.yacl.gui.TextScaledButtonWidget;
import dev.isxander.yacl.gui.YACLScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5489;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class OptionListWidget
extends class_4265<Entry> {
    private final YACLScreen yaclScreen;
    private boolean singleCategory = false;
    private ImmutableList<Entry> viewableChildren;
    private double smoothScrollAmount = this.method_25341();
    private boolean returnSmoothAmount = false;

    public OptionListWidget(YACLScreen screen, class_310 client, int width, int height) {
        super(client, width / 3 * 2, height, 0, height, 22);
        this.yaclScreen = screen;
        this.field_19088 = width - this.field_22742;
        this.field_19087 = width;
        this.refreshOptions();
    }

    public void refreshOptions() {
        this.method_25339();
        ArrayList<ConfigCategory> categories = new ArrayList<ConfigCategory>();
        if (this.yaclScreen.getCurrentCategoryIdx() == -1) {
            categories.addAll((Collection<ConfigCategory>)this.yaclScreen.config.categories());
        } else {
            categories.add((ConfigCategory)this.yaclScreen.config.categories().get(this.yaclScreen.getCurrentCategoryIdx()));
        }
        this.singleCategory = categories.size() == 1;
        for (ConfigCategory category : categories) {
            for (OptionGroup group : category.groups()) {
                Supplier<Boolean> viewableSupplier;
                GroupSeparatorEntry groupSeparatorEntry = null;
                if (!group.isRoot()) {
                    groupSeparatorEntry = new GroupSeparatorEntry(group, this.yaclScreen);
                    viewableSupplier = groupSeparatorEntry::isExpanded;
                    this.method_25321((class_350.class_351)groupSeparatorEntry);
                } else {
                    viewableSupplier = () -> true;
                }
                ArrayList<OptionEntry> optionEntries = new ArrayList<OptionEntry>();
                for (Option option : group.options()) {
                    OptionEntry entry = new OptionEntry(option, category, group, option.controller().provideWidget(this.yaclScreen, Dimension.ofInt(this.method_25342(), 0, this.method_25322(), 20)), viewableSupplier);
                    this.method_25321((class_350.class_351)entry);
                    optionEntries.add(entry);
                }
                if (groupSeparatorEntry == null) continue;
                groupSeparatorEntry.setOptionEntries(optionEntries);
            }
        }
        this.recacheViewableChildren();
        this.method_25307(0.0);
    }

    public void expandAllGroups() {
        for (Entry entry : super.method_25396()) {
            if (!(entry instanceof GroupSeparatorEntry)) continue;
            GroupSeparatorEntry groupSeparatorEntry = (GroupSeparatorEntry)entry;
            groupSeparatorEntry.setExpanded(true);
        }
    }

    @Nullable
    protected Entry getEntryAtPosition(double x, double y) {
        int listMiddleX = this.field_19088 + this.field_22742 / 2;
        int minX = listMiddleX - this.method_25322() / 2;
        int maxX = listMiddleX + this.method_25322() / 2;
        int currentY = class_3532.method_15357((double)(y - (double)this.field_19085)) - this.field_22748 + (int)this.method_25341() - 4;
        int itemY = 0;
        int itemIndex = -1;
        for (int i = 0; i < this.method_25396().size(); ++i) {
            Entry item = this.method_25396().get(i);
            if ((itemY += item.getItemHeight()) <= currentY) continue;
            itemIndex = i;
            break;
        }
        return x < (double)this.method_25329() && x >= (double)minX && y <= (double)maxX && itemIndex >= 0 && currentY >= 0 && itemIndex < this.method_25340() ? this.method_25396().get(itemIndex) : null;
    }

    protected int method_25317() {
        return this.method_25396().stream().map(Entry::getItemHeight).reduce(0, Integer::sum) + this.field_22748;
    }

    protected void centerScrollOn(Entry entry) {
        double d = (double)(this.field_19086 - this.field_19085) / -2.0;
        for (int i = 0; i < this.method_25396().indexOf((Object)entry) && i < this.method_25340(); ++i) {
            d += (double)this.method_25396().get(i).getItemHeight();
        }
        this.method_25307(d);
    }

    protected int method_25337(int index) {
        int integer = this.field_19085 + 4 - (int)this.method_25341() + this.field_22748;
        for (int i = 0; i < this.method_25396().size() && i < index; ++i) {
            integer += this.method_25396().get(i).getItemHeight();
        }
        return integer;
    }

    protected void method_25311(class_4587 matrices, int mouseX, int mouseY, float delta) {
        int left = this.method_25342();
        int right = this.method_25322();
        int count = this.method_25340();
        for (int i = 0; i < count; ++i) {
            Entry entry = this.method_25396().get(i);
            int top = this.method_25337(i);
            int bottom = top + entry.getItemHeight();
            int entryHeight = entry.getItemHeight() - 4;
            if (bottom < this.field_19085 || top > this.field_19086) continue;
            this.method_44397(matrices, mouseX, mouseY, delta, i, left, top, right, entryHeight);
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.smoothScrollAmount = class_3532.method_16436((double)((double)class_310.method_1551().method_1534() * 0.5), (double)this.smoothScrollAmount, (double)this.method_25341());
        this.returnSmoothAmount = true;
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.returnSmoothAmount = false;
    }

    public double method_25341() {
        if (this.returnSmoothAmount) {
            return this.smoothScrollAmount;
        }
        return super.method_25341();
    }

    public void postRender(class_4587 matrices, int mouseX, int mouseY, float delta) {
        for (Entry entry : this.method_25396()) {
            entry.postRender(matrices, mouseX, mouseY, delta);
        }
    }

    public int method_25322() {
        return Math.min(396, (int)((float)this.field_22742 / 1.3f));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (Entry child : this.method_25396()) {
            if (child == this.getEntryAtPosition(mouseX, mouseY) || !(child instanceof OptionEntry)) continue;
            OptionEntry optionEntry = (OptionEntry)child;
            optionEntry.widget.unfocus();
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        for (Entry child : this.method_25396()) {
            if (!child.method_25401(mouseX, mouseY, amount)) continue;
            return true;
        }
        this.method_25307(this.method_25341() - amount * 20.0);
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        for (Entry child : this.method_25396()) {
            if (!child.method_25404(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        for (Entry child : this.method_25396()) {
            if (!child.method_25400(chr, modifiers)) continue;
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    protected int method_25329() {
        return this.field_19088 + this.field_22742 - (int)((float)this.field_22742 * 0.05f);
    }

    protected void method_25325(class_4587 matrices) {
        this.method_31322(this.field_22740.field_1687 == null);
        if (this.field_22740.field_1687 != null) {
            OptionListWidget.method_25294((class_4587)matrices, (int)this.field_19088, (int)this.field_19085, (int)this.field_19087, (int)this.field_19086, (int)0x6B000000);
        }
    }

    public void recacheViewableChildren() {
        this.viewableChildren = ImmutableList.copyOf(super.method_25396().stream().filter(Entry::isViewable).toList());
        int i = 0;
        for (Entry entry : this.viewableChildren) {
            if (entry instanceof OptionEntry) {
                OptionEntry optionEntry = (OptionEntry)entry;
                optionEntry.widget.setDimension(optionEntry.widget.getDimension().withY(this.method_25337(i)));
            }
            ++i;
        }
    }

    public List<Entry> method_25396() {
        return this.viewableChildren;
    }

    public class GroupSeparatorEntry
    extends Entry {
        private final OptionGroup group;
        private final class_5489 wrappedName;
        private final class_5489 wrappedTooltip;
        private final LowProfileButtonWidget expandMinimizeButton;
        private final class_437 screen;
        private final class_327 textRenderer;
        private boolean groupExpanded;
        private List<OptionEntry> optionEntries;
        private int y;

        private GroupSeparatorEntry(OptionGroup group, class_437 screen) {
            this.textRenderer = class_310.method_1551().field_1772;
            this.group = group;
            this.screen = screen;
            this.wrappedName = class_5489.method_30890((class_327)this.textRenderer, (class_5348)group.name(), (int)(OptionListWidget.this.method_25322() - 45));
            this.wrappedTooltip = class_5489.method_30890((class_327)this.textRenderer, (class_5348)group.tooltip(), (int)(screen.field_22789 / 3 * 2 - 10));
            this.groupExpanded = !group.collapsed();
            this.expandMinimizeButton = new LowProfileButtonWidget(0, 0, 20, 20, (class_2561)class_2561.method_43473(), btn -> {
                this.setExpanded(!this.isExpanded());
                OptionListWidget.this.recacheViewableChildren();
            });
            this.updateExpandMinimizeText();
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.y = y;
            this.expandMinimizeButton.field_22760 = x;
            this.expandMinimizeButton.field_22761 = y + entryHeight / 2 - this.expandMinimizeButton.method_25364() / 2;
            this.expandMinimizeButton.method_25394(matrices, mouseX, mouseY, tickDelta);
            this.wrappedName.method_30888(matrices, x + entryWidth / 2, y + this.getYPadding());
        }

        @Override
        public void postRender(class_4587 matrices, int mouseX, int mouseY, float delta) {
            if (this.isHovered() && !this.expandMinimizeButton.method_25405(mouseX, mouseY)) {
                YACLScreen.renderMultilineTooltip(matrices, this.textRenderer, this.wrappedTooltip, OptionListWidget.this.method_25342() + OptionListWidget.this.method_25322() / 2, this.y - 3, this.y + this.getItemHeight() + 3, this.screen.field_22789, this.screen.field_22790);
            }
        }

        public boolean isExpanded() {
            return this.groupExpanded;
        }

        public void setExpanded(boolean expanded) {
            this.groupExpanded = expanded;
            this.updateExpandMinimizeText();
        }

        private void updateExpandMinimizeText() {
            this.expandMinimizeButton.method_25355(class_2561.method_30163((String)(this.isExpanded() ? "\u25bc" : "\u25b6")));
        }

        public void setOptionEntries(List<OptionEntry> optionEntries) {
            this.optionEntries = optionEntries;
        }

        @Override
        public boolean isViewable() {
            return OptionListWidget.this.yaclScreen.searchFieldWidget.isEmpty() || this.optionEntries.stream().anyMatch(OptionEntry::isViewable);
        }

        @Override
        public int getItemHeight() {
            int n = Math.max(this.wrappedName.method_30887(), 1);
            Objects.requireNonNull(this.textRenderer);
            return n * 9 + this.getYPadding() * 2;
        }

        private int getYPadding() {
            return 6;
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 builder) {
                    builder.method_37034(class_6381.field_33788, GroupSeparatorEntry.this.group.name());
                }
            });
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)((Object)this.expandMinimizeButton));
        }
    }

    public class OptionEntry
    extends Entry {
        public final Option<?> option;
        public final ConfigCategory category;
        public final OptionGroup group;
        public final AbstractWidget widget;
        private final Supplier<Boolean> viewableSupplier;
        private final TextScaledButtonWidget resetButton;
        private final String categoryName;
        private final String groupName;

        private OptionEntry(Option<?> option, ConfigCategory category, OptionGroup group, AbstractWidget widget, Supplier<Boolean> viewableSupplier) {
            this.option = option;
            this.category = category;
            this.group = group;
            this.widget = widget;
            this.viewableSupplier = viewableSupplier;
            this.categoryName = category.name().getString().toLowerCase();
            this.groupName = group.name().getString().toLowerCase();
            if (this.widget.canReset()) {
                this.widget.setDimension(this.widget.getDimension().expanded(-21, 0));
                this.resetButton = new TextScaledButtonWidget(widget.getDimension().xLimit() + 1, -50, 20, 20, 2.0f, class_2561.method_30163((String)"\u21bb"), button -> option.requestSetDefault());
                option.addListener((opt, val) -> {
                    this.resetButton.field_22763 = !opt.isPendingValueDefault() && opt.available();
                });
                this.resetButton.field_22763 = !option.isPendingValueDefault() && option.available();
            } else {
                this.resetButton = null;
            }
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.widget.setDimension(this.widget.getDimension().withY(y));
            this.widget.method_25394(matrices, mouseX, mouseY, tickDelta);
            if (this.resetButton != null) {
                this.resetButton.field_22761 = y;
                this.resetButton.method_25394(matrices, mouseX, mouseY, tickDelta);
            }
        }

        @Override
        public void postRender(class_4587 matrices, int mouseX, int mouseY, float delta) {
            this.widget.postRender(matrices, mouseX, mouseY, delta);
        }

        public boolean method_25401(double mouseX, double mouseY, double amount) {
            return this.widget.method_25401(mouseX, mouseY, amount);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            return this.widget.method_25404(keyCode, scanCode, modifiers);
        }

        public boolean method_25400(char chr, int modifiers) {
            return this.widget.method_25400(chr, modifiers);
        }

        @Override
        public boolean isViewable() {
            String query = OptionListWidget.this.yaclScreen.searchFieldWidget.method_1882();
            return this.viewableSupplier.get() != false && (OptionListWidget.this.yaclScreen.searchFieldWidget.isEmpty() || !OptionListWidget.this.singleCategory && this.categoryName.contains(query) || this.groupName.contains(query) || this.widget.matchesSearch(query));
        }

        @Override
        public int getItemHeight() {
            return this.widget.getDimension().height() + 2;
        }

        public List<? extends class_6379> method_37025() {
            if (this.resetButton == null) {
                return ImmutableList.of((Object)this.widget);
            }
            return ImmutableList.of((Object)this.widget, (Object)((Object)this.resetButton));
        }

        public List<? extends class_364> method_25396() {
            if (this.resetButton == null) {
                return ImmutableList.of((Object)this.widget);
            }
            return ImmutableList.of((Object)this.widget, (Object)((Object)this.resetButton));
        }
    }

    public abstract class Entry
    extends class_4265.class_4266<Entry> {
        public void postRender(class_4587 matrices, int mouseX, int mouseY, float delta) {
        }

        public boolean isViewable() {
            return true;
        }

        public int getItemHeight() {
            return 22;
        }

        protected boolean isHovered() {
            return Objects.equals(OptionListWidget.this.method_37019(), (Object)this);
        }
    }
}

